// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Namespace / NotificationHub Regenerate Keys request. </summary>
    public partial class NotificationHubPolicyKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubPolicyKey"/>. </summary>
        /// <param name="policyKey"> Type of Shared Access Policy Key (primary or secondary). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyKey"/> is null. </exception>
        public NotificationHubPolicyKey(string policyKey)
        {
            Argument.AssertNotNull(policyKey, nameof(policyKey));

            PolicyKey = policyKey;
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubPolicyKey"/>. </summary>
        /// <param name="policyKey"> Type of Shared Access Policy Key (primary or secondary). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubPolicyKey(string policyKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PolicyKey = policyKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }
    }
}
