// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> A collection of network authorization rules. </summary>
    public partial class NotificationHubNetworkAcls
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubNetworkAcls"/>. </summary>
        public NotificationHubNetworkAcls()
        {
            IPRules = new ChangeTrackingList<NotificationHubIPRule>();
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubNetworkAcls"/>. </summary>
        /// <param name="ipRules"> List of IP rules. </param>
        /// <param name="publicNetworkRule"> A default (public Internet) network authorization rule, which contains rights if no other network rule matches. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubNetworkAcls(IList<NotificationHubIPRule> ipRules, PublicInternetAuthorizationRule publicNetworkRule, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPRules = ipRules;
            PublicNetworkRule = publicNetworkRule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of IP rules. </summary>
        public IList<NotificationHubIPRule> IPRules { get; }
        /// <summary> A default (public Internet) network authorization rule, which contains rights if no other network rule matches. </summary>
        internal PublicInternetAuthorizationRule PublicNetworkRule { get; set; }
        /// <summary> List of access rights. </summary>
        public IList<AuthorizationRuleAccessRightExt> PublicNetworkRuleAccessRights
        {
            get => PublicNetworkRule is null ? default : PublicNetworkRule.AccessRights;
            set => PublicNetworkRule = new PublicInternetAuthorizationRule(value);
        }
    }
}
