// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Defines values for NamespaceType. </summary>
    public readonly partial struct NotificationHubNamespaceTypeExt : IEquatable<NotificationHubNamespaceTypeExt>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationHubNamespaceTypeExt"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationHubNamespaceTypeExt(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MessagingValue = "Messaging";
        private const string NotificationHubValue = "NotificationHub";

        /// <summary> Messaging. </summary>
        public static NotificationHubNamespaceTypeExt Messaging { get; } = new NotificationHubNamespaceTypeExt(MessagingValue);
        /// <summary> NotificationHub. </summary>
        public static NotificationHubNamespaceTypeExt NotificationHub { get; } = new NotificationHubNamespaceTypeExt(NotificationHubValue);
        /// <summary> Determines if two <see cref="NotificationHubNamespaceTypeExt"/> values are the same. </summary>
        public static bool operator ==(NotificationHubNamespaceTypeExt left, NotificationHubNamespaceTypeExt right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationHubNamespaceTypeExt"/> values are not the same. </summary>
        public static bool operator !=(NotificationHubNamespaceTypeExt left, NotificationHubNamespaceTypeExt right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationHubNamespaceTypeExt"/>. </summary>
        public static implicit operator NotificationHubNamespaceTypeExt(string value) => new NotificationHubNamespaceTypeExt(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationHubNamespaceTypeExt other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationHubNamespaceTypeExt other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
