// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Namespace status. </summary>
    public readonly partial struct NotificationHubNamespaceStatus : IEquatable<NotificationHubNamespaceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationHubNamespaceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationHubNamespaceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string CreatingValue = "Creating";
        private const string SuspendedValue = "Suspended";
        private const string DeletingValue = "Deleting";

        /// <summary> Created. </summary>
        public static NotificationHubNamespaceStatus Created { get; } = new NotificationHubNamespaceStatus(CreatedValue);
        /// <summary> Creating. </summary>
        public static NotificationHubNamespaceStatus Creating { get; } = new NotificationHubNamespaceStatus(CreatingValue);
        /// <summary> Suspended. </summary>
        public static NotificationHubNamespaceStatus Suspended { get; } = new NotificationHubNamespaceStatus(SuspendedValue);
        /// <summary> Deleting. </summary>
        public static NotificationHubNamespaceStatus Deleting { get; } = new NotificationHubNamespaceStatus(DeletingValue);
        /// <summary> Determines if two <see cref="NotificationHubNamespaceStatus"/> values are the same. </summary>
        public static bool operator ==(NotificationHubNamespaceStatus left, NotificationHubNamespaceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationHubNamespaceStatus"/> values are not the same. </summary>
        public static bool operator !=(NotificationHubNamespaceStatus left, NotificationHubNamespaceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationHubNamespaceStatus"/>. </summary>
        public static implicit operator NotificationHubNamespaceStatus(string value) => new NotificationHubNamespaceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationHubNamespaceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationHubNamespaceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
