// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Description of a NotificationHub GcmCredential. </summary>
    public partial class NotificationHubGcmCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationHubGcmCredential"/>. </summary>
        /// <param name="gcmApiKey"> Gets or sets the Google API key. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="gcmApiKey"/> is null. </exception>
        public NotificationHubGcmCredential(string gcmApiKey)
        {
            Argument.AssertNotNull(gcmApiKey, nameof(gcmApiKey));

            GcmApiKey = gcmApiKey;
        }

        /// <summary> Initializes a new instance of <see cref="NotificationHubGcmCredential"/>. </summary>
        /// <param name="gcmEndpoint"> Gets or sets the GCM endpoint. </param>
        /// <param name="gcmApiKey"> Gets or sets the Google API key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationHubGcmCredential(Uri gcmEndpoint, string gcmApiKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GcmEndpoint = gcmEndpoint;
            GcmApiKey = gcmApiKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the GCM endpoint. </summary>
        public Uri GcmEndpoint { get; set; }
        /// <summary> Gets or sets the Google API key. </summary>
        public string GcmApiKey { get; set; }
    }
}
