// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Description of a NotificationHub FcmV1Credential. </summary>
    public partial class FcmV1Credential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FcmV1Credential"/>. </summary>
        /// <param name="clientEmail"> Gets or sets client email. </param>
        /// <param name="privateKey"> Gets or sets private key. </param>
        /// <param name="projectId"> Gets or sets project id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientEmail"/>, <paramref name="privateKey"/> or <paramref name="projectId"/> is null. </exception>
        public FcmV1Credential(string clientEmail, string privateKey, string projectId)
        {
            Argument.AssertNotNull(clientEmail, nameof(clientEmail));
            Argument.AssertNotNull(privateKey, nameof(privateKey));
            Argument.AssertNotNull(projectId, nameof(projectId));

            ClientEmail = clientEmail;
            PrivateKey = privateKey;
            ProjectId = projectId;
        }

        /// <summary> Initializes a new instance of <see cref="FcmV1Credential"/>. </summary>
        /// <param name="clientEmail"> Gets or sets client email. </param>
        /// <param name="privateKey"> Gets or sets private key. </param>
        /// <param name="projectId"> Gets or sets project id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FcmV1Credential(string clientEmail, string privateKey, string projectId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientEmail = clientEmail;
            PrivateKey = privateKey;
            ProjectId = projectId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FcmV1Credential"/> for deserialization. </summary>
        internal FcmV1Credential()
        {
        }

        /// <summary> Gets or sets client email. </summary>
        public string ClientEmail { get; set; }
        /// <summary> Gets or sets private key. </summary>
        public string PrivateKey { get; set; }
        /// <summary> Gets or sets project id. </summary>
        public string ProjectId { get; set; }
    }
}
