// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NotificationHubs.Models
{
    /// <summary> Defines values for AccessRights. </summary>
    public readonly partial struct AuthorizationRuleAccessRightExt : IEquatable<AuthorizationRuleAccessRightExt>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthorizationRuleAccessRightExt"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthorizationRuleAccessRightExt(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManageValue = "Manage";
        private const string SendValue = "Send";
        private const string ListenValue = "Listen";

        /// <summary> Manage. </summary>
        public static AuthorizationRuleAccessRightExt Manage { get; } = new AuthorizationRuleAccessRightExt(ManageValue);
        /// <summary> Send. </summary>
        public static AuthorizationRuleAccessRightExt Send { get; } = new AuthorizationRuleAccessRightExt(SendValue);
        /// <summary> Listen. </summary>
        public static AuthorizationRuleAccessRightExt Listen { get; } = new AuthorizationRuleAccessRightExt(ListenValue);
        /// <summary> Determines if two <see cref="AuthorizationRuleAccessRightExt"/> values are the same. </summary>
        public static bool operator ==(AuthorizationRuleAccessRightExt left, AuthorizationRuleAccessRightExt right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthorizationRuleAccessRightExt"/> values are not the same. </summary>
        public static bool operator !=(AuthorizationRuleAccessRightExt left, AuthorizationRuleAccessRightExt right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthorizationRuleAccessRightExt"/>. </summary>
        public static implicit operator AuthorizationRuleAccessRightExt(string value) => new AuthorizationRuleAccessRightExt(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthorizationRuleAccessRightExt other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthorizationRuleAccessRightExt other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
