// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Nginx.Models
{
    public partial class WebApplicationFirewallStatus : IUtf8JsonSerializable, IJsonModel<WebApplicationFirewallStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<WebApplicationFirewallStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<WebApplicationFirewallStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebApplicationFirewallStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WebApplicationFirewallStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(AttackSignaturesPackage))
            {
                writer.WritePropertyName("attackSignaturesPackage"u8);
                writer.WriteObjectValue(AttackSignaturesPackage, options);
            }
            if (options.Format != "W" && Optional.IsDefined(BotSignaturesPackage))
            {
                writer.WritePropertyName("botSignaturesPackage"u8);
                writer.WriteObjectValue(BotSignaturesPackage, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ThreatCampaignsPackage))
            {
                writer.WritePropertyName("threatCampaignsPackage"u8);
                writer.WriteObjectValue(ThreatCampaignsPackage, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ComponentVersions))
            {
                writer.WritePropertyName("componentVersions"u8);
                writer.WriteObjectValue(ComponentVersions, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        WebApplicationFirewallStatus IJsonModel<WebApplicationFirewallStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebApplicationFirewallStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(WebApplicationFirewallStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeWebApplicationFirewallStatus(document.RootElement, options);
        }

        internal static WebApplicationFirewallStatus DeserializeWebApplicationFirewallStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WebApplicationFirewallPackage attackSignaturesPackage = default;
            WebApplicationFirewallPackage botSignaturesPackage = default;
            WebApplicationFirewallPackage threatCampaignsPackage = default;
            WebApplicationFirewallComponentVersions componentVersions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("attackSignaturesPackage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    attackSignaturesPackage = WebApplicationFirewallPackage.DeserializeWebApplicationFirewallPackage(property.Value, options);
                    continue;
                }
                if (property.NameEquals("botSignaturesPackage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    botSignaturesPackage = WebApplicationFirewallPackage.DeserializeWebApplicationFirewallPackage(property.Value, options);
                    continue;
                }
                if (property.NameEquals("threatCampaignsPackage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    threatCampaignsPackage = WebApplicationFirewallPackage.DeserializeWebApplicationFirewallPackage(property.Value, options);
                    continue;
                }
                if (property.NameEquals("componentVersions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    componentVersions = WebApplicationFirewallComponentVersions.DeserializeWebApplicationFirewallComponentVersions(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new WebApplicationFirewallStatus(attackSignaturesPackage, botSignaturesPackage, threatCampaignsPackage, componentVersions, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<WebApplicationFirewallStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebApplicationFirewallStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(WebApplicationFirewallStatus)} does not support writing '{options.Format}' format.");
            }
        }

        WebApplicationFirewallStatus IPersistableModel<WebApplicationFirewallStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<WebApplicationFirewallStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeWebApplicationFirewallStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(WebApplicationFirewallStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<WebApplicationFirewallStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
