// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The activation state of the WAF. Use 'Enabled' to enable the WAF and 'Disabled' to disable it. </summary>
    public readonly partial struct WebApplicationFirewallActivationState : IEquatable<WebApplicationFirewallActivationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationFirewallActivationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationFirewallActivationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static WebApplicationFirewallActivationState Enabled { get; } = new WebApplicationFirewallActivationState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static WebApplicationFirewallActivationState Disabled { get; } = new WebApplicationFirewallActivationState(DisabledValue);
        /// <summary> Determines if two <see cref="WebApplicationFirewallActivationState"/> values are the same. </summary>
        public static bool operator ==(WebApplicationFirewallActivationState left, WebApplicationFirewallActivationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationFirewallActivationState"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationFirewallActivationState left, WebApplicationFirewallActivationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationFirewallActivationState"/>. </summary>
        public static implicit operator WebApplicationFirewallActivationState(string value) => new WebApplicationFirewallActivationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationFirewallActivationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationFirewallActivationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
