// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The autoscale profile. </summary>
    public partial class NginxScaleProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxScaleProfile"/>. </summary>
        /// <param name="name"></param>
        /// <param name="capacity"> The capacity parameters of the profile. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="capacity"/> is null. </exception>
        public NginxScaleProfile(string name, NginxScaleProfileCapacity capacity)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(capacity, nameof(capacity));

            Name = name;
            Capacity = capacity;
        }

        /// <summary> Initializes a new instance of <see cref="NginxScaleProfile"/>. </summary>
        /// <param name="name"></param>
        /// <param name="capacity"> The capacity parameters of the profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxScaleProfile(string name, NginxScaleProfileCapacity capacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Capacity = capacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NginxScaleProfile"/> for deserialization. </summary>
        internal NginxScaleProfile()
        {
        }

        /// <summary> Gets or sets the name. </summary>
        public string Name { get; set; }
        /// <summary> The capacity parameters of the profile. </summary>
        public NginxScaleProfileCapacity Capacity { get; set; }
    }
}
