// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxProvisioningState. </summary>
    public readonly partial struct NginxProvisioningState : IEquatable<NginxProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NginxProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NginxProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Accepted. </summary>
        public static NginxProvisioningState Accepted { get; } = new NginxProvisioningState(AcceptedValue);
        /// <summary> Creating. </summary>
        public static NginxProvisioningState Creating { get; } = new NginxProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NginxProvisioningState Updating { get; } = new NginxProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NginxProvisioningState Deleting { get; } = new NginxProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static NginxProvisioningState Succeeded { get; } = new NginxProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static NginxProvisioningState Failed { get; } = new NginxProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static NginxProvisioningState Canceled { get; } = new NginxProvisioningState(CanceledValue);
        /// <summary> Deleted. </summary>
        public static NginxProvisioningState Deleted { get; } = new NginxProvisioningState(DeletedValue);
        /// <summary> NotSpecified. </summary>
        public static NginxProvisioningState NotSpecified { get; } = new NginxProvisioningState(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="NginxProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NginxProvisioningState left, NginxProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NginxProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NginxProvisioningState left, NginxProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NginxProvisioningState"/>. </summary>
        public static implicit operator NginxProvisioningState(string value) => new NginxProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NginxProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NginxProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
