// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxFrontendIPConfiguration. </summary>
    public partial class NginxFrontendIPConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxFrontendIPConfiguration"/>. </summary>
        public NginxFrontendIPConfiguration()
        {
            PublicIPAddresses = new ChangeTrackingList<WritableSubResource>();
            PrivateIPAddresses = new ChangeTrackingList<NginxPrivateIPAddress>();
        }

        /// <summary> Initializes a new instance of <see cref="NginxFrontendIPConfiguration"/>. </summary>
        /// <param name="publicIPAddresses"> Gets the public ip addresses. </param>
        /// <param name="privateIPAddresses"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxFrontendIPConfiguration(IList<WritableSubResource> publicIPAddresses, IList<NginxPrivateIPAddress> privateIPAddresses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublicIPAddresses = publicIPAddresses;
            PrivateIPAddresses = privateIPAddresses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the public ip addresses. </summary>
        public IList<WritableSubResource> PublicIPAddresses { get; }
        /// <summary> Gets the private ip addresses. </summary>
        public IList<NginxPrivateIPAddress> PrivateIPAddresses { get; }
    }
}
