// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxDeploymentUpdateProperties. </summary>
    public partial class NginxDeploymentUpdateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentUpdateProperties"/>. </summary>
        public NginxDeploymentUpdateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentUpdateProperties"/>. </summary>
        /// <param name="enableDiagnosticsSupport"></param>
        /// <param name="logging"></param>
        /// <param name="scalingProperties"> Information on how the deployment will be scaled. </param>
        /// <param name="userProfile"></param>
        /// <param name="autoUpgradeProfile"> Autoupgrade settings of a deployment. </param>
        /// <param name="nginxAppProtect"> Update settings for NGINX App Protect (NAP). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxDeploymentUpdateProperties(bool? enableDiagnosticsSupport, NginxLogging logging, NginxDeploymentScalingProperties scalingProperties, NginxDeploymentUserProfile userProfile, AutoUpgradeProfile autoUpgradeProfile, NginxDeploymentUpdatePropertiesNginxAppProtect nginxAppProtect, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EnableDiagnosticsSupport = enableDiagnosticsSupport;
            Logging = logging;
            ScalingProperties = scalingProperties;
            UserProfile = userProfile;
            AutoUpgradeProfile = autoUpgradeProfile;
            NginxAppProtect = nginxAppProtect;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the enable diagnostics support. </summary>
        public bool? EnableDiagnosticsSupport { get; set; }
        /// <summary> Gets or sets the logging. </summary>
        internal NginxLogging Logging { get; set; }
        /// <summary> Gets or sets the logging storage account. </summary>
        public NginxStorageAccount LoggingStorageAccount
        {
            get => Logging is null ? default : Logging.StorageAccount;
            set
            {
                if (Logging is null)
                    Logging = new NginxLogging();
                Logging.StorageAccount = value;
            }
        }

        /// <summary> Information on how the deployment will be scaled. </summary>
        public NginxDeploymentScalingProperties ScalingProperties { get; set; }
        /// <summary> Gets or sets the user profile. </summary>
        internal NginxDeploymentUserProfile UserProfile { get; set; }
        /// <summary> The preferred support contact email address of the user used for sending alerts and notification. Can be an empty string or a valid email address. </summary>
        public string UserPreferredEmail
        {
            get => UserProfile is null ? default : UserProfile.PreferredEmail;
            set
            {
                if (UserProfile is null)
                    UserProfile = new NginxDeploymentUserProfile();
                UserProfile.PreferredEmail = value;
            }
        }

        /// <summary> Autoupgrade settings of a deployment. </summary>
        internal AutoUpgradeProfile AutoUpgradeProfile { get; set; }
        /// <summary> Channel used for autoupgrade. </summary>
        public string UpgradeChannel
        {
            get => AutoUpgradeProfile is null ? default : AutoUpgradeProfile.UpgradeChannel;
            set => AutoUpgradeProfile = new AutoUpgradeProfile(value);
        }

        /// <summary> Update settings for NGINX App Protect (NAP). </summary>
        internal NginxDeploymentUpdatePropertiesNginxAppProtect NginxAppProtect { get; set; }
        /// <summary> The activation state of the WAF. Use 'Enabled' to enable the WAF and 'Disabled' to disable it. </summary>
        public WebApplicationFirewallActivationState? WebApplicationFirewallActivationState
        {
            get => NginxAppProtect is null ? default : NginxAppProtect.WebApplicationFirewallActivationState;
            set
            {
                if (NginxAppProtect is null)
                    NginxAppProtect = new NginxDeploymentUpdatePropertiesNginxAppProtect();
                NginxAppProtect.WebApplicationFirewallActivationState = value;
            }
        }
    }
}
