// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Nginx.Models
{
    public partial class NginxDeploymentUpdateProperties : IUtf8JsonSerializable, IJsonModel<NginxDeploymentUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NginxDeploymentUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NginxDeploymentUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NginxDeploymentUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NginxDeploymentUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EnableDiagnosticsSupport))
            {
                writer.WritePropertyName("enableDiagnosticsSupport"u8);
                writer.WriteBooleanValue(EnableDiagnosticsSupport.Value);
            }
            if (Optional.IsDefined(Logging))
            {
                writer.WritePropertyName("logging"u8);
                writer.WriteObjectValue(Logging, options);
            }
            if (Optional.IsDefined(ScalingProperties))
            {
                writer.WritePropertyName("scalingProperties"u8);
                writer.WriteObjectValue(ScalingProperties, options);
            }
            if (Optional.IsDefined(UserProfile))
            {
                writer.WritePropertyName("userProfile"u8);
                writer.WriteObjectValue(UserProfile, options);
            }
            if (Optional.IsDefined(AutoUpgradeProfile))
            {
                writer.WritePropertyName("autoUpgradeProfile"u8);
                writer.WriteObjectValue(AutoUpgradeProfile, options);
            }
            if (Optional.IsDefined(NginxAppProtect))
            {
                writer.WritePropertyName("nginxAppProtect"u8);
                writer.WriteObjectValue(NginxAppProtect, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NginxDeploymentUpdateProperties IJsonModel<NginxDeploymentUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NginxDeploymentUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NginxDeploymentUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNginxDeploymentUpdateProperties(document.RootElement, options);
        }

        internal static NginxDeploymentUpdateProperties DeserializeNginxDeploymentUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? enableDiagnosticsSupport = default;
            NginxLogging logging = default;
            NginxDeploymentScalingProperties scalingProperties = default;
            NginxDeploymentUserProfile userProfile = default;
            AutoUpgradeProfile autoUpgradeProfile = default;
            NginxDeploymentUpdatePropertiesNginxAppProtect nginxAppProtect = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enableDiagnosticsSupport"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableDiagnosticsSupport = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("logging"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logging = NginxLogging.DeserializeNginxLogging(property.Value, options);
                    continue;
                }
                if (property.NameEquals("scalingProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scalingProperties = NginxDeploymentScalingProperties.DeserializeNginxDeploymentScalingProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("userProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userProfile = NginxDeploymentUserProfile.DeserializeNginxDeploymentUserProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("autoUpgradeProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoUpgradeProfile = AutoUpgradeProfile.DeserializeAutoUpgradeProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("nginxAppProtect"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nginxAppProtect = NginxDeploymentUpdatePropertiesNginxAppProtect.DeserializeNginxDeploymentUpdatePropertiesNginxAppProtect(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NginxDeploymentUpdateProperties(
                enableDiagnosticsSupport,
                logging,
                scalingProperties,
                userProfile,
                autoUpgradeProfile,
                nginxAppProtect,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NginxDeploymentUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NginxDeploymentUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NginxDeploymentUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        NginxDeploymentUpdateProperties IPersistableModel<NginxDeploymentUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NginxDeploymentUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNginxDeploymentUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NginxDeploymentUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NginxDeploymentUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
