// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> Information on how the deployment will be scaled. </summary>
    public partial class NginxDeploymentScalingProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentScalingProperties"/>. </summary>
        public NginxDeploymentScalingProperties()
        {
            Profiles = new ChangeTrackingList<NginxScaleProfile>();
        }

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentScalingProperties"/>. </summary>
        /// <param name="capacity"></param>
        /// <param name="profiles"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxDeploymentScalingProperties(int? capacity, IList<NginxScaleProfile> profiles, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Capacity = capacity;
            Profiles = profiles;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the capacity. </summary>
        public int? Capacity { get; set; }
        /// <summary> Gets the profiles. </summary>
        public IList<NginxScaleProfile> Profiles { get; }
    }
}
