// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> Settings for NGINX App Protect (NAP). </summary>
    public partial class NginxDeploymentPropertiesNginxAppProtect
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentPropertiesNginxAppProtect"/>. </summary>
        /// <param name="webApplicationFirewallSettings"> Settings for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="webApplicationFirewallSettings"/> is null. </exception>
        public NginxDeploymentPropertiesNginxAppProtect(WebApplicationFirewallSettings webApplicationFirewallSettings)
        {
            Argument.AssertNotNull(webApplicationFirewallSettings, nameof(webApplicationFirewallSettings));

            WebApplicationFirewallSettings = webApplicationFirewallSettings;
        }

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentPropertiesNginxAppProtect"/>. </summary>
        /// <param name="webApplicationFirewallSettings"> Settings for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <param name="webApplicationFirewallStatus"> The status of the NGINX App Protect Web Application Firewall. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxDeploymentPropertiesNginxAppProtect(WebApplicationFirewallSettings webApplicationFirewallSettings, WebApplicationFirewallStatus webApplicationFirewallStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WebApplicationFirewallSettings = webApplicationFirewallSettings;
            WebApplicationFirewallStatus = webApplicationFirewallStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentPropertiesNginxAppProtect"/> for deserialization. </summary>
        internal NginxDeploymentPropertiesNginxAppProtect()
        {
        }

        /// <summary> Settings for the NGINX App Protect Web Application Firewall (WAF). </summary>
        internal WebApplicationFirewallSettings WebApplicationFirewallSettings { get; set; }
        /// <summary> The activation state of the WAF. Use 'Enabled' to enable the WAF and 'Disabled' to disable it. </summary>
        public WebApplicationFirewallActivationState? WebApplicationFirewallActivationState
        {
            get => WebApplicationFirewallSettings is null ? default : WebApplicationFirewallSettings.ActivationState;
            set
            {
                if (WebApplicationFirewallSettings is null)
                    WebApplicationFirewallSettings = new WebApplicationFirewallSettings();
                WebApplicationFirewallSettings.ActivationState = value;
            }
        }

        /// <summary> The status of the NGINX App Protect Web Application Firewall. </summary>
        public WebApplicationFirewallStatus WebApplicationFirewallStatus { get; }
    }
}
