// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxDeploymentProperties. </summary>
    public partial class NginxDeploymentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentProperties"/>. </summary>
        public NginxDeploymentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NginxDeploymentProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="nginxVersion"></param>
        /// <param name="managedResourceGroup"> The managed resource group to deploy VNet injection related network resources. </param>
        /// <param name="networkProfile"></param>
        /// <param name="ipAddress"> The IP address of the deployment. </param>
        /// <param name="enableDiagnosticsSupport"></param>
        /// <param name="logging"></param>
        /// <param name="scalingProperties"> Information on how the deployment will be scaled. </param>
        /// <param name="autoUpgradeProfile"> Autoupgrade settings of a deployment. </param>
        /// <param name="userProfile"></param>
        /// <param name="nginxAppProtect"> Settings for NGINX App Protect (NAP). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxDeploymentProperties(NginxProvisioningState? provisioningState, string nginxVersion, string managedResourceGroup, NginxNetworkProfile networkProfile, string ipAddress, bool? enableDiagnosticsSupport, NginxLogging logging, NginxDeploymentScalingProperties scalingProperties, AutoUpgradeProfile autoUpgradeProfile, NginxDeploymentUserProfile userProfile, NginxDeploymentPropertiesNginxAppProtect nginxAppProtect, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            NginxVersion = nginxVersion;
            ManagedResourceGroup = managedResourceGroup;
            NetworkProfile = networkProfile;
            IPAddress = ipAddress;
            EnableDiagnosticsSupport = enableDiagnosticsSupport;
            Logging = logging;
            ScalingProperties = scalingProperties;
            AutoUpgradeProfile = autoUpgradeProfile;
            UserProfile = userProfile;
            NginxAppProtect = nginxAppProtect;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state. </summary>
        public NginxProvisioningState? ProvisioningState { get; }
        /// <summary> Gets the nginx version. </summary>
        public string NginxVersion { get; }
        /// <summary> The managed resource group to deploy VNet injection related network resources. </summary>
        public string ManagedResourceGroup { get; set; }
        /// <summary> Gets or sets the network profile. </summary>
        public NginxNetworkProfile NetworkProfile { get; set; }
        /// <summary> The IP address of the deployment. </summary>
        public string IPAddress { get; }
        /// <summary> Gets or sets the enable diagnostics support. </summary>
        public bool? EnableDiagnosticsSupport { get; set; }
        /// <summary> Gets or sets the logging. </summary>
        internal NginxLogging Logging { get; set; }
        /// <summary> Gets or sets the logging storage account. </summary>
        public NginxStorageAccount LoggingStorageAccount
        {
            get => Logging is null ? default : Logging.StorageAccount;
            set
            {
                if (Logging is null)
                    Logging = new NginxLogging();
                Logging.StorageAccount = value;
            }
        }

        /// <summary> Information on how the deployment will be scaled. </summary>
        public NginxDeploymentScalingProperties ScalingProperties { get; set; }
        /// <summary> Autoupgrade settings of a deployment. </summary>
        internal AutoUpgradeProfile AutoUpgradeProfile { get; set; }
        /// <summary> Channel used for autoupgrade. </summary>
        public string UpgradeChannel
        {
            get => AutoUpgradeProfile is null ? default : AutoUpgradeProfile.UpgradeChannel;
            set => AutoUpgradeProfile = new AutoUpgradeProfile(value);
        }

        /// <summary> Gets or sets the user profile. </summary>
        internal NginxDeploymentUserProfile UserProfile { get; set; }
        /// <summary> The preferred support contact email address of the user used for sending alerts and notification. Can be an empty string or a valid email address. </summary>
        public string UserPreferredEmail
        {
            get => UserProfile is null ? default : UserProfile.PreferredEmail;
            set
            {
                if (UserProfile is null)
                    UserProfile = new NginxDeploymentUserProfile();
                UserProfile.PreferredEmail = value;
            }
        }

        /// <summary> Settings for NGINX App Protect (NAP). </summary>
        public NginxDeploymentPropertiesNginxAppProtect NginxAppProtect { get; set; }
    }
}
