// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxCertificateProperties. </summary>
    public partial class NginxCertificateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxCertificateProperties"/>. </summary>
        public NginxCertificateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NginxCertificateProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="keyVirtualPath"></param>
        /// <param name="certificateVirtualPath"></param>
        /// <param name="keyVaultSecretId"></param>
        /// <param name="sha1Thumbprint"></param>
        /// <param name="keyVaultSecretVersion"></param>
        /// <param name="keyVaultSecretCreated"></param>
        /// <param name="certificateError"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxCertificateProperties(NginxProvisioningState? provisioningState, string keyVirtualPath, string certificateVirtualPath, string keyVaultSecretId, string sha1Thumbprint, string keyVaultSecretVersion, DateTimeOffset? keyVaultSecretCreated, NginxCertificateError certificateError, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            KeyVirtualPath = keyVirtualPath;
            CertificateVirtualPath = certificateVirtualPath;
            KeyVaultSecretId = keyVaultSecretId;
            Sha1Thumbprint = sha1Thumbprint;
            KeyVaultSecretVersion = keyVaultSecretVersion;
            KeyVaultSecretCreated = keyVaultSecretCreated;
            CertificateError = certificateError;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state. </summary>
        public NginxProvisioningState? ProvisioningState { get; }
        /// <summary> Gets or sets the key virtual path. </summary>
        public string KeyVirtualPath { get; set; }
        /// <summary> Gets or sets the certificate virtual path. </summary>
        public string CertificateVirtualPath { get; set; }
        /// <summary> Gets or sets the key vault secret id. </summary>
        public string KeyVaultSecretId { get; set; }
        /// <summary> Gets the sha 1 thumbprint. </summary>
        public string Sha1Thumbprint { get; }
        /// <summary> Gets the key vault secret version. </summary>
        public string KeyVaultSecretVersion { get; }
        /// <summary> Gets the key vault secret created. </summary>
        public DateTimeOffset? KeyVaultSecretCreated { get; }
        /// <summary> Gets or sets the certificate error. </summary>
        public NginxCertificateError CertificateError { get; set; }
    }
}
