// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The request body for creating an analysis for an NGINX configuration. </summary>
    public partial class NginxAnalysisContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxAnalysisContent"/>. </summary>
        /// <param name="config"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="config"/> is null. </exception>
        public NginxAnalysisContent(NginxAnalysisConfig config)
        {
            Argument.AssertNotNull(config, nameof(config));

            Config = config;
        }

        /// <summary> Initializes a new instance of <see cref="NginxAnalysisContent"/>. </summary>
        /// <param name="config"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxAnalysisContent(NginxAnalysisConfig config, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Config = config;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NginxAnalysisContent"/> for deserialization. </summary>
        internal NginxAnalysisContent()
        {
        }

        /// <summary> Gets the config. </summary>
        public NginxAnalysisConfig Config { get; }
    }
}
