// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> The NginxAnalysisConfig. </summary>
    public partial class NginxAnalysisConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NginxAnalysisConfig"/>. </summary>
        public NginxAnalysisConfig()
        {
            Files = new ChangeTrackingList<NginxConfigurationFile>();
            ProtectedFiles = new ChangeTrackingList<NginxConfigurationFile>();
        }

        /// <summary> Initializes a new instance of <see cref="NginxAnalysisConfig"/>. </summary>
        /// <param name="rootFile"> The root file of the NGINX config file(s). It must match one of the files' filepath. </param>
        /// <param name="files"></param>
        /// <param name="protectedFiles"></param>
        /// <param name="package"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NginxAnalysisConfig(string rootFile, IList<NginxConfigurationFile> files, IList<NginxConfigurationFile> protectedFiles, NginxConfigurationPackage package, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RootFile = rootFile;
            Files = files;
            ProtectedFiles = protectedFiles;
            Package = package;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The root file of the NGINX config file(s). It must match one of the files' filepath. </summary>
        public string RootFile { get; set; }
        /// <summary> Gets the files. </summary>
        public IList<NginxConfigurationFile> Files { get; }
        /// <summary> Gets the protected files. </summary>
        public IList<NginxConfigurationFile> ProtectedFiles { get; }
        /// <summary> Gets or sets the package. </summary>
        public NginxConfigurationPackage Package { get; set; }
    }
}
