// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> Autoupgrade settings of a deployment. </summary>
    internal partial class AutoUpgradeProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeProfile"/>. </summary>
        /// <param name="upgradeChannel"> Channel used for autoupgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="upgradeChannel"/> is null. </exception>
        public AutoUpgradeProfile(string upgradeChannel)
        {
            Argument.AssertNotNull(upgradeChannel, nameof(upgradeChannel));

            UpgradeChannel = upgradeChannel;
        }

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeProfile"/>. </summary>
        /// <param name="upgradeChannel"> Channel used for autoupgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoUpgradeProfile(string upgradeChannel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpgradeChannel = upgradeChannel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutoUpgradeProfile"/> for deserialization. </summary>
        internal AutoUpgradeProfile()
        {
        }

        /// <summary> Channel used for autoupgrade. </summary>
        public string UpgradeChannel { get; set; }
    }
}
