// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Nginx
{
    internal class NginxDeploymentOperationSource : IOperationSource<NginxDeploymentResource>
    {
        private readonly ArmClient _client;

        internal NginxDeploymentOperationSource(ArmClient client)
        {
            _client = client;
        }

        NginxDeploymentResource IOperationSource<NginxDeploymentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NginxDeploymentData.DeserializeNginxDeploymentData(document.RootElement);
            return new NginxDeploymentResource(_client, data);
        }

        async ValueTask<NginxDeploymentResource> IOperationSource<NginxDeploymentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NginxDeploymentData.DeserializeNginxDeploymentData(document.RootElement);
            return new NginxDeploymentResource(_client, data);
        }
    }
}
