// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Nginx.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmNginxModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Nginx.NginxCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <param name="location"></param>
        /// <returns> A new <see cref="Nginx.NginxCertificateData"/> instance for mocking. </returns>
        public static NginxCertificateData NginxCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NginxCertificateProperties properties = null, AzureLocation? location = null)
        {
            return new NginxCertificateData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxCertificateProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="keyVirtualPath"></param>
        /// <param name="certificateVirtualPath"></param>
        /// <param name="keyVaultSecretId"></param>
        /// <param name="sha1Thumbprint"></param>
        /// <param name="keyVaultSecretVersion"></param>
        /// <param name="keyVaultSecretCreated"></param>
        /// <param name="certificateError"></param>
        /// <returns> A new <see cref="Models.NginxCertificateProperties"/> instance for mocking. </returns>
        public static NginxCertificateProperties NginxCertificateProperties(NginxProvisioningState? provisioningState = null, string keyVirtualPath = null, string certificateVirtualPath = null, string keyVaultSecretId = null, string sha1Thumbprint = null, string keyVaultSecretVersion = null, DateTimeOffset? keyVaultSecretCreated = null, NginxCertificateError certificateError = null)
        {
            return new NginxCertificateProperties(
                provisioningState,
                keyVirtualPath,
                certificateVirtualPath,
                keyVaultSecretId,
                sha1Thumbprint,
                keyVaultSecretVersion,
                keyVaultSecretCreated,
                certificateError,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Nginx.NginxConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <param name="location"></param>
        /// <returns> A new <see cref="Nginx.NginxConfigurationData"/> instance for mocking. </returns>
        public static NginxConfigurationData NginxConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NginxConfigurationProperties properties = null, AzureLocation? location = null)
        {
            return new NginxConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxConfigurationProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="files"></param>
        /// <param name="protectedFiles"></param>
        /// <param name="package"></param>
        /// <param name="rootFile"></param>
        /// <returns> A new <see cref="Models.NginxConfigurationProperties"/> instance for mocking. </returns>
        public static NginxConfigurationProperties NginxConfigurationProperties(NginxProvisioningState? provisioningState = null, IEnumerable<NginxConfigurationFile> files = null, IEnumerable<NginxConfigurationFile> protectedFiles = null, NginxConfigurationPackage package = null, string rootFile = null)
        {
            files ??= new List<NginxConfigurationFile>();
            protectedFiles ??= new List<NginxConfigurationFile>();

            return new NginxConfigurationProperties(
                provisioningState,
                files?.ToList(),
                protectedFiles?.ToList(),
                package,
                rootFile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxAnalysisResult"/>. </summary>
        /// <param name="status"> The status of the analysis. </param>
        /// <param name="dataErrors"></param>
        /// <returns> A new <see cref="Models.NginxAnalysisResult"/> instance for mocking. </returns>
        public static NginxAnalysisResult NginxAnalysisResult(string status = null, IEnumerable<NginxAnalysisDiagnostic> dataErrors = null)
        {
            dataErrors ??= new List<NginxAnalysisDiagnostic>();

            return new NginxAnalysisResult(status, dataErrors != null ? new AnalysisResultData(dataErrors?.ToList(), serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxAnalysisDiagnostic"/>. </summary>
        /// <param name="id"> Unique identifier for the error. </param>
        /// <param name="directive"></param>
        /// <param name="description"></param>
        /// <param name="file"> the filepath of the most relevant config file. </param>
        /// <param name="line"></param>
        /// <param name="message"></param>
        /// <param name="rule"></param>
        /// <returns> A new <see cref="Models.NginxAnalysisDiagnostic"/> instance for mocking. </returns>
        public static NginxAnalysisDiagnostic NginxAnalysisDiagnostic(string id = null, string directive = null, string description = null, string file = null, float line = default, string message = null, string rule = null)
        {
            return new NginxAnalysisDiagnostic(
                id,
                directive,
                description,
                file,
                line,
                message,
                rule,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Nginx.NginxDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Gets or sets the identity. </param>
        /// <param name="properties"></param>
        /// <param name="skuName"></param>
        /// <returns> A new <see cref="Nginx.NginxDeploymentData"/> instance for mocking. </returns>
        public static NginxDeploymentData NginxDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, NginxDeploymentProperties properties = null, string skuName = null)
        {
            tags ??= new Dictionary<string, string>();

            return new NginxDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                properties,
                skuName != null ? new NginxResourceSku(skuName, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxDeploymentProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="nginxVersion"></param>
        /// <param name="managedResourceGroup"> The managed resource group to deploy VNet injection related network resources. </param>
        /// <param name="networkProfile"></param>
        /// <param name="ipAddress"> The IP address of the deployment. </param>
        /// <param name="enableDiagnosticsSupport"></param>
        /// <param name="loggingStorageAccount"></param>
        /// <param name="scalingProperties"> Information on how the deployment will be scaled. </param>
        /// <param name="upgradeChannel"> Autoupgrade settings of a deployment. </param>
        /// <param name="userPreferredEmail"></param>
        /// <param name="nginxAppProtect"> Settings for NGINX App Protect (NAP). </param>
        /// <returns> A new <see cref="Models.NginxDeploymentProperties"/> instance for mocking. </returns>
        public static NginxDeploymentProperties NginxDeploymentProperties(NginxProvisioningState? provisioningState = null, string nginxVersion = null, string managedResourceGroup = null, NginxNetworkProfile networkProfile = null, string ipAddress = null, bool? enableDiagnosticsSupport = null, NginxStorageAccount loggingStorageAccount = null, NginxDeploymentScalingProperties scalingProperties = null, string upgradeChannel = null, string userPreferredEmail = null, NginxDeploymentPropertiesNginxAppProtect nginxAppProtect = null)
        {
            return new NginxDeploymentProperties(
                provisioningState,
                nginxVersion,
                managedResourceGroup,
                networkProfile,
                ipAddress,
                enableDiagnosticsSupport,
                loggingStorageAccount != null ? new NginxLogging(loggingStorageAccount, serializedAdditionalRawData: null) : null,
                scalingProperties,
                upgradeChannel != null ? new AutoUpgradeProfile(upgradeChannel, serializedAdditionalRawData: null) : null,
                userPreferredEmail != null ? new NginxDeploymentUserProfile(userPreferredEmail, serializedAdditionalRawData: null) : null,
                nginxAppProtect,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NginxDeploymentPropertiesNginxAppProtect"/>. </summary>
        /// <param name="webApplicationFirewallActivationState"> Settings for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <param name="webApplicationFirewallStatus"> The status of the NGINX App Protect Web Application Firewall. </param>
        /// <returns> A new <see cref="Models.NginxDeploymentPropertiesNginxAppProtect"/> instance for mocking. </returns>
        public static NginxDeploymentPropertiesNginxAppProtect NginxDeploymentPropertiesNginxAppProtect(WebApplicationFirewallActivationState? webApplicationFirewallActivationState = null, WebApplicationFirewallStatus webApplicationFirewallStatus = null)
        {
            return new NginxDeploymentPropertiesNginxAppProtect(webApplicationFirewallActivationState != null ? new WebApplicationFirewallSettings(webApplicationFirewallActivationState, serializedAdditionalRawData: null) : null, webApplicationFirewallStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebApplicationFirewallStatus"/>. </summary>
        /// <param name="attackSignaturesPackage"> Package containing attack signatures for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <param name="botSignaturesPackage"> Package containing bot signatures for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <param name="threatCampaignsPackage"> Package containing threat campaigns for the NGINX App Protect Web Application Firewall (WAF). </param>
        /// <param name="componentVersions"> Versions of the NGINX App Protect Web Application Firewall (WAF) components. </param>
        /// <returns> A new <see cref="Models.WebApplicationFirewallStatus"/> instance for mocking. </returns>
        public static WebApplicationFirewallStatus WebApplicationFirewallStatus(WebApplicationFirewallPackage attackSignaturesPackage = null, WebApplicationFirewallPackage botSignaturesPackage = null, WebApplicationFirewallPackage threatCampaignsPackage = null, WebApplicationFirewallComponentVersions componentVersions = null)
        {
            return new WebApplicationFirewallStatus(attackSignaturesPackage, botSignaturesPackage, threatCampaignsPackage, componentVersions, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebApplicationFirewallPackage"/>. </summary>
        /// <param name="version"> The version of the NGINX App Protect Web Application Firewall (WAF) package. </param>
        /// <param name="revisionDatetime"> The date and time of the package revision. </param>
        /// <returns> A new <see cref="Models.WebApplicationFirewallPackage"/> instance for mocking. </returns>
        public static WebApplicationFirewallPackage WebApplicationFirewallPackage(string version = null, DateTimeOffset revisionDatetime = default)
        {
            return new WebApplicationFirewallPackage(version, revisionDatetime, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WebApplicationFirewallComponentVersions"/>. </summary>
        /// <param name="wafEngineVersion"> The version of the NGINX App Protect Web Application Firewall (WAF) engine. </param>
        /// <param name="wafNginxVersion"> The version of the NGINX App Protect Web Application Firewall (WAF) module for NGINX. </param>
        /// <returns> A new <see cref="Models.WebApplicationFirewallComponentVersions"/> instance for mocking. </returns>
        public static WebApplicationFirewallComponentVersions WebApplicationFirewallComponentVersions(string wafEngineVersion = null, string wafNginxVersion = null)
        {
            return new WebApplicationFirewallComponentVersions(wafEngineVersion, wafNginxVersion, serializedAdditionalRawData: null);
        }
    }
}
