// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NewRelicObservability.Models;

namespace Azure.ResourceManager.NewRelicObservability
{
    public partial class NewRelicMonitorResourceData : IUtf8JsonSerializable, IJsonModel<NewRelicMonitorResourceData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NewRelicMonitorResourceData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NewRelicMonitorResourceData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NewRelicMonitorResourceData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NewRelicMonitorResourceData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MonitoringStatus))
            {
                writer.WritePropertyName("monitoringStatus"u8);
                writer.WriteStringValue(MonitoringStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MarketplaceSubscriptionStatus))
            {
                writer.WritePropertyName("marketplaceSubscriptionStatus"u8);
                writer.WriteStringValue(MarketplaceSubscriptionStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MarketplaceSubscriptionId))
            {
                writer.WritePropertyName("marketplaceSubscriptionId"u8);
                writer.WriteStringValue(MarketplaceSubscriptionId);
            }
            if (Optional.IsDefined(NewRelicAccountProperties))
            {
                writer.WritePropertyName("newRelicAccountProperties"u8);
                writer.WriteObjectValue(NewRelicAccountProperties, options);
            }
            if (Optional.IsDefined(UserInfo))
            {
                writer.WritePropertyName("userInfo"u8);
                writer.WriteObjectValue(UserInfo, options);
            }
            if (Optional.IsDefined(PlanData))
            {
                writer.WritePropertyName("planData"u8);
                writer.WriteObjectValue(PlanData, options);
            }
            if (options.Format != "W" && Optional.IsDefined(LiftrResourceCategory))
            {
                writer.WritePropertyName("liftrResourceCategory"u8);
                writer.WriteStringValue(LiftrResourceCategory.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LiftrResourcePreference))
            {
                writer.WritePropertyName("liftrResourcePreference"u8);
                writer.WriteNumberValue(LiftrResourcePreference.Value);
            }
            if (Optional.IsDefined(OrgCreationSource))
            {
                writer.WritePropertyName("orgCreationSource"u8);
                writer.WriteStringValue(OrgCreationSource.Value.ToString());
            }
            if (Optional.IsDefined(AccountCreationSource))
            {
                writer.WritePropertyName("accountCreationSource"u8);
                writer.WriteStringValue(AccountCreationSource.Value.ToString());
            }
            if (Optional.IsDefined(SubscriptionState))
            {
                writer.WritePropertyName("subscriptionState"u8);
                writer.WriteStringValue(SubscriptionState);
            }
            if (Optional.IsDefined(SaaSAzureSubscriptionStatus))
            {
                writer.WritePropertyName("saaSAzureSubscriptionStatus"u8);
                writer.WriteStringValue(SaaSAzureSubscriptionStatus);
            }
            writer.WriteEndObject();
        }

        NewRelicMonitorResourceData IJsonModel<NewRelicMonitorResourceData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NewRelicMonitorResourceData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NewRelicMonitorResourceData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNewRelicMonitorResourceData(document.RootElement, options);
        }

        internal static NewRelicMonitorResourceData DeserializeNewRelicMonitorResourceData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            NewRelicProvisioningState? provisioningState = default;
            NewRelicObservabilityMonitoringStatus? monitoringStatus = default;
            NewRelicObservabilityMarketplaceSubscriptionStatus? marketplaceSubscriptionStatus = default;
            string marketplaceSubscriptionId = default;
            NewRelicAccountProperties newRelicAccountProperties = default;
            NewRelicObservabilityUserInfo userInfo = default;
            NewRelicPlanDetails planData = default;
            NewRelicLiftrResourceCategory? liftrResourceCategory = default;
            int? liftrResourcePreference = default;
            NewRelicObservabilityOrgCreationSource? orgCreationSource = default;
            NewRelicObservabilityAccountCreationSource? accountCreationSource = default;
            string subscriptionState = default;
            string saaSAzureSubscriptionStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new NewRelicProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("monitoringStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            monitoringStatus = new NewRelicObservabilityMonitoringStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("marketplaceSubscriptionStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            marketplaceSubscriptionStatus = new NewRelicObservabilityMarketplaceSubscriptionStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("marketplaceSubscriptionId"u8))
                        {
                            marketplaceSubscriptionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("newRelicAccountProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            newRelicAccountProperties = NewRelicAccountProperties.DeserializeNewRelicAccountProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("userInfo"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            userInfo = NewRelicObservabilityUserInfo.DeserializeNewRelicObservabilityUserInfo(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("planData"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            planData = NewRelicPlanDetails.DeserializeNewRelicPlanDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("liftrResourceCategory"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            liftrResourceCategory = new NewRelicLiftrResourceCategory(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("liftrResourcePreference"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            liftrResourcePreference = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("orgCreationSource"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            orgCreationSource = new NewRelicObservabilityOrgCreationSource(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("accountCreationSource"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            accountCreationSource = new NewRelicObservabilityAccountCreationSource(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("subscriptionState"u8))
                        {
                            subscriptionState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("saaSAzureSubscriptionStatus"u8))
                        {
                            saaSAzureSubscriptionStatus = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NewRelicMonitorResourceData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                identity,
                provisioningState,
                monitoringStatus,
                marketplaceSubscriptionStatus,
                marketplaceSubscriptionId,
                newRelicAccountProperties,
                userInfo,
                planData,
                liftrResourceCategory,
                liftrResourcePreference,
                orgCreationSource,
                accountCreationSource,
                subscriptionState,
                saaSAzureSubscriptionStatus,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Identity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Identity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Identity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MonitoringStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    monitoringStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MonitoringStatus))
                {
                    builder.Append("    monitoringStatus: ");
                    builder.AppendLine($"'{MonitoringStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MarketplaceSubscriptionStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    marketplaceSubscriptionStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MarketplaceSubscriptionStatus))
                {
                    builder.Append("    marketplaceSubscriptionStatus: ");
                    builder.AppendLine($"'{MarketplaceSubscriptionStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MarketplaceSubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    marketplaceSubscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MarketplaceSubscriptionId))
                {
                    builder.Append("    marketplaceSubscriptionId: ");
                    if (MarketplaceSubscriptionId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MarketplaceSubscriptionId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MarketplaceSubscriptionId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NewRelicAccountProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    newRelicAccountProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NewRelicAccountProperties))
                {
                    builder.Append("    newRelicAccountProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NewRelicAccountProperties, options, 4, false, "    newRelicAccountProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UserInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    userInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UserInfo))
                {
                    builder.Append("    userInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UserInfo, options, 4, false, "    userInfo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PlanData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    planData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PlanData))
                {
                    builder.Append("    planData: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PlanData, options, 4, false, "    planData: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LiftrResourceCategory), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    liftrResourceCategory: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LiftrResourceCategory))
                {
                    builder.Append("    liftrResourceCategory: ");
                    builder.AppendLine($"'{LiftrResourceCategory.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LiftrResourcePreference), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    liftrResourcePreference: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LiftrResourcePreference))
                {
                    builder.Append("    liftrResourcePreference: ");
                    builder.AppendLine($"{LiftrResourcePreference.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OrgCreationSource), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    orgCreationSource: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OrgCreationSource))
                {
                    builder.Append("    orgCreationSource: ");
                    builder.AppendLine($"'{OrgCreationSource.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AccountCreationSource), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    accountCreationSource: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AccountCreationSource))
                {
                    builder.Append("    accountCreationSource: ");
                    builder.AppendLine($"'{AccountCreationSource.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    subscriptionState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionState))
                {
                    builder.Append("    subscriptionState: ");
                    if (SubscriptionState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SubscriptionState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SubscriptionState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SaaSAzureSubscriptionStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    saaSAzureSubscriptionStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SaaSAzureSubscriptionStatus))
                {
                    builder.Append("    saaSAzureSubscriptionStatus: ");
                    if (SaaSAzureSubscriptionStatus.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SaaSAzureSubscriptionStatus}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SaaSAzureSubscriptionStatus}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<NewRelicMonitorResourceData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NewRelicMonitorResourceData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(NewRelicMonitorResourceData)} does not support writing '{options.Format}' format.");
            }
        }

        NewRelicMonitorResourceData IPersistableModel<NewRelicMonitorResourceData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NewRelicMonitorResourceData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNewRelicMonitorResourceData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NewRelicMonitorResourceData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NewRelicMonitorResourceData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
