// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Provisioning State of the Monitor resource. </summary>
    public readonly partial struct NewRelicProvisioningState : IEquatable<NewRelicProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string NotSpecifiedValue = "NotSpecified";

        /// <summary> Monitor resource creation request accepted. </summary>
        public static NewRelicProvisioningState Accepted { get; } = new NewRelicProvisioningState(AcceptedValue);
        /// <summary> Monitor resource creation started. </summary>
        public static NewRelicProvisioningState Creating { get; } = new NewRelicProvisioningState(CreatingValue);
        /// <summary> Monitor resource is being updated. </summary>
        public static NewRelicProvisioningState Updating { get; } = new NewRelicProvisioningState(UpdatingValue);
        /// <summary> Monitor resource deletion started. </summary>
        public static NewRelicProvisioningState Deleting { get; } = new NewRelicProvisioningState(DeletingValue);
        /// <summary> Monitor resource creation successful. </summary>
        public static NewRelicProvisioningState Succeeded { get; } = new NewRelicProvisioningState(SucceededValue);
        /// <summary> Monitor resource creation failed. </summary>
        public static NewRelicProvisioningState Failed { get; } = new NewRelicProvisioningState(FailedValue);
        /// <summary> Monitor resource creation canceled. </summary>
        public static NewRelicProvisioningState Canceled { get; } = new NewRelicProvisioningState(CanceledValue);
        /// <summary> Monitor resource is deleted. </summary>
        public static NewRelicProvisioningState Deleted { get; } = new NewRelicProvisioningState(DeletedValue);
        /// <summary> Monitor resource state is unknown. </summary>
        public static NewRelicProvisioningState NotSpecified { get; } = new NewRelicProvisioningState(NotSpecifiedValue);
        /// <summary> Determines if two <see cref="NewRelicProvisioningState"/> values are the same. </summary>
        public static bool operator ==(NewRelicProvisioningState left, NewRelicProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(NewRelicProvisioningState left, NewRelicProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicProvisioningState"/>. </summary>
        public static implicit operator NewRelicProvisioningState(string value) => new NewRelicProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
