// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> The details of a PlanData resource. </summary>
    public partial class NewRelicPlanData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NewRelicPlanData"/>. </summary>
        public NewRelicPlanData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NewRelicPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="planData"> Plan details. </param>
        /// <param name="orgCreationSource"> Source of org creation. </param>
        /// <param name="accountCreationSource"> Source of account creation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NewRelicPlanData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, NewRelicPlanDetails planData, NewRelicObservabilityOrgCreationSource? orgCreationSource, NewRelicObservabilityAccountCreationSource? accountCreationSource, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PlanData = planData;
            OrgCreationSource = orgCreationSource;
            AccountCreationSource = accountCreationSource;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Plan details. </summary>
        [WirePath("properties.planData")]
        public NewRelicPlanDetails PlanData { get; set; }
        /// <summary> Source of org creation. </summary>
        [WirePath("properties.orgCreationSource")]
        public NewRelicObservabilityOrgCreationSource? OrgCreationSource { get; set; }
        /// <summary> Source of account creation. </summary>
        [WirePath("properties.accountCreationSource")]
        public NewRelicObservabilityAccountCreationSource? AccountCreationSource { get; set; }
    }
}
