// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Details of VM Resource having NewRelic OneAgent installed. </summary>
    public partial class NewRelicObservabilityVmInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityVmInfo"/>. </summary>
        internal NewRelicObservabilityVmInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityVmInfo"/>. </summary>
        /// <param name="vmId"> Azure VM resource ID. </param>
        /// <param name="agentVersion"> Version of the NewRelic agent installed on the VM. </param>
        /// <param name="agentStatus"> Status of the NewRelic agent installed on the VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NewRelicObservabilityVmInfo(ResourceIdentifier vmId, string agentVersion, string agentStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmId = vmId;
            AgentVersion = agentVersion;
            AgentStatus = agentStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure VM resource ID. </summary>
        [WirePath("vmId")]
        public ResourceIdentifier VmId { get; }
        /// <summary> Version of the NewRelic agent installed on the VM. </summary>
        [WirePath("agentVersion")]
        public string AgentVersion { get; }
        /// <summary> Status of the NewRelic agent installed on the VM. </summary>
        [WirePath("agentStatus")]
        public string AgentStatus { get; }
    }
}
