// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Different usage type like PAYG/COMMITTED. </summary>
    public readonly partial struct NewRelicObservabilityUsageType : IEquatable<NewRelicObservabilityUsageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityUsageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityUsageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PaygValue = "PAYG";
        private const string CommittedValue = "COMMITTED";

        /// <summary> Usage type is PAYG. </summary>
        public static NewRelicObservabilityUsageType Payg { get; } = new NewRelicObservabilityUsageType(PaygValue);
        /// <summary> Usage type is COMMITTED. </summary>
        public static NewRelicObservabilityUsageType Committed { get; } = new NewRelicObservabilityUsageType(CommittedValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityUsageType"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityUsageType left, NewRelicObservabilityUsageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityUsageType"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityUsageType left, NewRelicObservabilityUsageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityUsageType"/>. </summary>
        public static implicit operator NewRelicObservabilityUsageType(string value) => new NewRelicObservabilityUsageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityUsageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityUsageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
