// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Indicates whether metrics are being sent. </summary>
    public readonly partial struct NewRelicObservabilitySendingMetricsStatus : IEquatable<NewRelicObservabilitySendingMetricsStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilitySendingMetricsStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilitySendingMetricsStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static NewRelicObservabilitySendingMetricsStatus IsEnabled { get; } = new NewRelicObservabilitySendingMetricsStatus(IsEnabledValue);
        /// <summary> Disabled. </summary>
        public static NewRelicObservabilitySendingMetricsStatus IsDisabled { get; } = new NewRelicObservabilitySendingMetricsStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendingMetricsStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilitySendingMetricsStatus left, NewRelicObservabilitySendingMetricsStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendingMetricsStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilitySendingMetricsStatus left, NewRelicObservabilitySendingMetricsStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilitySendingMetricsStatus"/>. </summary>
        public static implicit operator NewRelicObservabilitySendingMetricsStatus(string value) => new NewRelicObservabilitySendingMetricsStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilitySendingMetricsStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilitySendingMetricsStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
