// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Indicates whether subscription logs are being sent. </summary>
    public readonly partial struct NewRelicObservabilitySendSubscriptionLogsStatus : IEquatable<NewRelicObservabilitySendSubscriptionLogsStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilitySendSubscriptionLogsStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilitySendSubscriptionLogsStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static NewRelicObservabilitySendSubscriptionLogsStatus IsEnabled { get; } = new NewRelicObservabilitySendSubscriptionLogsStatus(IsEnabledValue);
        /// <summary> Disabled. </summary>
        public static NewRelicObservabilitySendSubscriptionLogsStatus IsDisabled { get; } = new NewRelicObservabilitySendSubscriptionLogsStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendSubscriptionLogsStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilitySendSubscriptionLogsStatus left, NewRelicObservabilitySendSubscriptionLogsStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendSubscriptionLogsStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilitySendSubscriptionLogsStatus left, NewRelicObservabilitySendSubscriptionLogsStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilitySendSubscriptionLogsStatus"/>. </summary>
        public static implicit operator NewRelicObservabilitySendSubscriptionLogsStatus(string value) => new NewRelicObservabilitySendSubscriptionLogsStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilitySendSubscriptionLogsStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilitySendSubscriptionLogsStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
