// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Indicates whether metrics are being sent. </summary>
    public readonly partial struct NewRelicObservabilitySendMetricsStatus : IEquatable<NewRelicObservabilitySendMetricsStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilitySendMetricsStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilitySendMetricsStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static NewRelicObservabilitySendMetricsStatus Enabled { get; } = new NewRelicObservabilitySendMetricsStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static NewRelicObservabilitySendMetricsStatus Disabled { get; } = new NewRelicObservabilitySendMetricsStatus(DisabledValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendMetricsStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilitySendMetricsStatus left, NewRelicObservabilitySendMetricsStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendMetricsStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilitySendMetricsStatus left, NewRelicObservabilitySendMetricsStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilitySendMetricsStatus"/>. </summary>
        public static implicit operator NewRelicObservabilitySendMetricsStatus(string value) => new NewRelicObservabilitySendMetricsStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilitySendMetricsStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilitySendMetricsStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
