// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Indicates whether activity logs are being sent. </summary>
    public readonly partial struct NewRelicObservabilitySendActivityLogsStatus : IEquatable<NewRelicObservabilitySendActivityLogsStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilitySendActivityLogsStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilitySendActivityLogsStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static NewRelicObservabilitySendActivityLogsStatus IsEnabled { get; } = new NewRelicObservabilitySendActivityLogsStatus(IsEnabledValue);
        /// <summary> Disabled. </summary>
        public static NewRelicObservabilitySendActivityLogsStatus IsDisabled { get; } = new NewRelicObservabilitySendActivityLogsStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendActivityLogsStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilitySendActivityLogsStatus left, NewRelicObservabilitySendActivityLogsStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilitySendActivityLogsStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilitySendActivityLogsStatus left, NewRelicObservabilitySendActivityLogsStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilitySendActivityLogsStatus"/>. </summary>
        public static implicit operator NewRelicObservabilitySendActivityLogsStatus(string value) => new NewRelicObservabilitySendActivityLogsStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilitySendActivityLogsStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilitySendActivityLogsStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
