// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Source of Org creation. </summary>
    public readonly partial struct NewRelicObservabilityOrgCreationSource : IEquatable<NewRelicObservabilityOrgCreationSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityOrgCreationSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityOrgCreationSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LiftrValue = "LIFTR";
        private const string NewrelicValue = "NEWRELIC";

        /// <summary> Org is created from LIFTR. </summary>
        public static NewRelicObservabilityOrgCreationSource Liftr { get; } = new NewRelicObservabilityOrgCreationSource(LiftrValue);
        /// <summary> Org is created from NEWRELIC. </summary>
        public static NewRelicObservabilityOrgCreationSource Newrelic { get; } = new NewRelicObservabilityOrgCreationSource(NewrelicValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityOrgCreationSource"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityOrgCreationSource left, NewRelicObservabilityOrgCreationSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityOrgCreationSource"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityOrgCreationSource left, NewRelicObservabilityOrgCreationSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityOrgCreationSource"/>. </summary>
        public static implicit operator NewRelicObservabilityOrgCreationSource(string value) => new NewRelicObservabilityOrgCreationSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityOrgCreationSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityOrgCreationSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
