// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Flag specifying if the resource monitoring is enabled or disabled. </summary>
    public readonly partial struct NewRelicObservabilityMonitoringStatus : IEquatable<NewRelicObservabilityMonitoringStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityMonitoringStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityMonitoringStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> monitoring is enabled. </summary>
        public static NewRelicObservabilityMonitoringStatus IsEnabled { get; } = new NewRelicObservabilityMonitoringStatus(IsEnabledValue);
        /// <summary> monitoring is disabled. </summary>
        public static NewRelicObservabilityMonitoringStatus IsDisabled { get; } = new NewRelicObservabilityMonitoringStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityMonitoringStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityMonitoringStatus left, NewRelicObservabilityMonitoringStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityMonitoringStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityMonitoringStatus left, NewRelicObservabilityMonitoringStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityMonitoringStatus"/>. </summary>
        public static implicit operator NewRelicObservabilityMonitoringStatus(string value) => new NewRelicObservabilityMonitoringStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityMonitoringStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityMonitoringStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
