// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. </summary>
    public readonly partial struct NewRelicObservabilityMarketplaceSubscriptionStatus : IEquatable<NewRelicObservabilityMarketplaceSubscriptionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityMarketplaceSubscriptionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityMarketplaceSubscriptionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string SuspendedValue = "Suspended";

        /// <summary> monitoring is enabled. </summary>
        public static NewRelicObservabilityMarketplaceSubscriptionStatus Active { get; } = new NewRelicObservabilityMarketplaceSubscriptionStatus(ActiveValue);
        /// <summary> monitoring is disabled. </summary>
        public static NewRelicObservabilityMarketplaceSubscriptionStatus Suspended { get; } = new NewRelicObservabilityMarketplaceSubscriptionStatus(SuspendedValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityMarketplaceSubscriptionStatus"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityMarketplaceSubscriptionStatus left, NewRelicObservabilityMarketplaceSubscriptionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityMarketplaceSubscriptionStatus"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityMarketplaceSubscriptionStatus left, NewRelicObservabilityMarketplaceSubscriptionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityMarketplaceSubscriptionStatus"/>. </summary>
        public static implicit operator NewRelicObservabilityMarketplaceSubscriptionStatus(string value) => new NewRelicObservabilityMarketplaceSubscriptionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityMarketplaceSubscriptionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityMarketplaceSubscriptionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
