// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Billing source. </summary>
    public readonly partial struct NewRelicObservabilityBillingSource : IEquatable<NewRelicObservabilityBillingSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityBillingSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityBillingSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "AZURE";
        private const string NewrelicValue = "NEWRELIC";

        /// <summary> Billing source is Azure. </summary>
        public static NewRelicObservabilityBillingSource Azure { get; } = new NewRelicObservabilityBillingSource(AzureValue);
        /// <summary> NEWRELIC. </summary>
        public static NewRelicObservabilityBillingSource Newrelic { get; } = new NewRelicObservabilityBillingSource(NewrelicValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityBillingSource"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityBillingSource left, NewRelicObservabilityBillingSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityBillingSource"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityBillingSource left, NewRelicObservabilityBillingSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityBillingSource"/>. </summary>
        public static implicit operator NewRelicObservabilityBillingSource(string value) => new NewRelicObservabilityBillingSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityBillingSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityBillingSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
