// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Source of Account creation. </summary>
    public readonly partial struct NewRelicObservabilityAccountCreationSource : IEquatable<NewRelicObservabilityAccountCreationSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NewRelicObservabilityAccountCreationSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NewRelicObservabilityAccountCreationSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LiftrValue = "LIFTR";
        private const string NewrelicValue = "NEWRELIC";

        /// <summary> Account is created from LIFTR. </summary>
        public static NewRelicObservabilityAccountCreationSource Liftr { get; } = new NewRelicObservabilityAccountCreationSource(LiftrValue);
        /// <summary> Account is created from NEWRELIC. </summary>
        public static NewRelicObservabilityAccountCreationSource Newrelic { get; } = new NewRelicObservabilityAccountCreationSource(NewrelicValue);
        /// <summary> Determines if two <see cref="NewRelicObservabilityAccountCreationSource"/> values are the same. </summary>
        public static bool operator ==(NewRelicObservabilityAccountCreationSource left, NewRelicObservabilityAccountCreationSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NewRelicObservabilityAccountCreationSource"/> values are not the same. </summary>
        public static bool operator !=(NewRelicObservabilityAccountCreationSource left, NewRelicObservabilityAccountCreationSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NewRelicObservabilityAccountCreationSource"/>. </summary>
        public static implicit operator NewRelicObservabilityAccountCreationSource(string value) => new NewRelicObservabilityAccountCreationSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NewRelicObservabilityAccountCreationSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NewRelicObservabilityAccountCreationSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
