// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> The type used for update operations of the NewRelicMonitorResource. </summary>
    public partial class NewRelicMonitorResourcePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NewRelicMonitorResourcePatch"/>. </summary>
        public NewRelicMonitorResourcePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="NewRelicMonitorResourcePatch"/>. </summary>
        /// <param name="identity"> The managed service identities assigned to this resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="newRelicAccountProperties"> MarketplaceSubscriptionStatus of the resource. </param>
        /// <param name="userInfo"> User Info. </param>
        /// <param name="planData"> Plan details. </param>
        /// <param name="orgCreationSource"> Source of org creation. </param>
        /// <param name="accountCreationSource"> Source of account creation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NewRelicMonitorResourcePatch(ManagedServiceIdentity identity, IDictionary<string, string> tags, NewRelicAccountProperties newRelicAccountProperties, NewRelicObservabilityUserInfo userInfo, NewRelicPlanDetails planData, NewRelicObservabilityOrgCreationSource? orgCreationSource, NewRelicObservabilityAccountCreationSource? accountCreationSource, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Identity = identity;
            Tags = tags;
            NewRelicAccountProperties = newRelicAccountProperties;
            UserInfo = userInfo;
            PlanData = planData;
            OrgCreationSource = orgCreationSource;
            AccountCreationSource = accountCreationSource;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The managed service identities assigned to this resource. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Resource tags. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> MarketplaceSubscriptionStatus of the resource. </summary>
        [WirePath("properties.newRelicAccountProperties")]
        public NewRelicAccountProperties NewRelicAccountProperties { get; set; }
        /// <summary> User Info. </summary>
        [WirePath("properties.userInfo")]
        public NewRelicObservabilityUserInfo UserInfo { get; set; }
        /// <summary> Plan details. </summary>
        [WirePath("properties.planData")]
        public NewRelicPlanDetails PlanData { get; set; }
        /// <summary> Source of org creation. </summary>
        [WirePath("properties.orgCreationSource")]
        public NewRelicObservabilityOrgCreationSource? OrgCreationSource { get; set; }
        /// <summary> Source of account creation. </summary>
        [WirePath("properties.accountCreationSource")]
        public NewRelicObservabilityAccountCreationSource? AccountCreationSource { get; set; }
    }
}
