// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> The operation for the patch on the resource. </summary>
    public readonly partial struct MonitoredSubscriptionPatchOperation : IEquatable<MonitoredSubscriptionPatchOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitoredSubscriptionPatchOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitoredSubscriptionPatchOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddBeginValue = "AddBegin";
        private const string AddCompleteValue = "AddComplete";
        private const string DeleteBeginValue = "DeleteBegin";
        private const string DeleteCompleteValue = "DeleteComplete";
        private const string ActiveValue = "Active";

        /// <summary> AddBegin. </summary>
        public static MonitoredSubscriptionPatchOperation AddBegin { get; } = new MonitoredSubscriptionPatchOperation(AddBeginValue);
        /// <summary> AddComplete. </summary>
        public static MonitoredSubscriptionPatchOperation AddComplete { get; } = new MonitoredSubscriptionPatchOperation(AddCompleteValue);
        /// <summary> DeleteBegin. </summary>
        public static MonitoredSubscriptionPatchOperation DeleteBegin { get; } = new MonitoredSubscriptionPatchOperation(DeleteBeginValue);
        /// <summary> DeleteComplete. </summary>
        public static MonitoredSubscriptionPatchOperation DeleteComplete { get; } = new MonitoredSubscriptionPatchOperation(DeleteCompleteValue);
        /// <summary> Active. </summary>
        public static MonitoredSubscriptionPatchOperation Active { get; } = new MonitoredSubscriptionPatchOperation(ActiveValue);
        /// <summary> Determines if two <see cref="MonitoredSubscriptionPatchOperation"/> values are the same. </summary>
        public static bool operator ==(MonitoredSubscriptionPatchOperation left, MonitoredSubscriptionPatchOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitoredSubscriptionPatchOperation"/> values are not the same. </summary>
        public static bool operator !=(MonitoredSubscriptionPatchOperation left, MonitoredSubscriptionPatchOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitoredSubscriptionPatchOperation"/>. </summary>
        public static implicit operator MonitoredSubscriptionPatchOperation(string value) => new MonitoredSubscriptionPatchOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitoredSubscriptionPatchOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitoredSubscriptionPatchOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
