// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> The MonitoredSubscriptionConfigurationName. </summary>
    public readonly partial struct MonitoredSubscriptionConfigurationName : IEquatable<MonitoredSubscriptionConfigurationName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitoredSubscriptionConfigurationName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitoredSubscriptionConfigurationName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static MonitoredSubscriptionConfigurationName Default { get; } = new MonitoredSubscriptionConfigurationName(DefaultValue);
        /// <summary> Determines if two <see cref="MonitoredSubscriptionConfigurationName"/> values are the same. </summary>
        public static bool operator ==(MonitoredSubscriptionConfigurationName left, MonitoredSubscriptionConfigurationName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitoredSubscriptionConfigurationName"/> values are not the same. </summary>
        public static bool operator !=(MonitoredSubscriptionConfigurationName left, MonitoredSubscriptionConfigurationName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitoredSubscriptionConfigurationName"/>. </summary>
        public static implicit operator MonitoredSubscriptionConfigurationName(string value) => new MonitoredSubscriptionConfigurationName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitoredSubscriptionConfigurationName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitoredSubscriptionConfigurationName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
