// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NewRelicObservability.Models
{
    /// <summary> Marketplace SAAS Info of the resource. </summary>
    public partial class MarketplaceSaaSInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MarketplaceSaaSInfo"/>. </summary>
        internal MarketplaceSaaSInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MarketplaceSaaSInfo"/>. </summary>
        /// <param name="marketplaceSubscriptionId"> Marketplace Subscription Id. This is a GUID-formatted string. </param>
        /// <param name="marketplaceSubscriptionName"> Marketplace Subscription Details: SAAS Name. </param>
        /// <param name="marketplaceResourceId"> Marketplace Subscription Details: Resource URI. </param>
        /// <param name="marketplaceStatus"> Marketplace Subscription Details: SaaS Subscription Status. </param>
        /// <param name="billedAzureSubscriptionId"> The Azure Subscription ID to which the Marketplace Subscription belongs and gets billed into. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MarketplaceSaaSInfo(string marketplaceSubscriptionId, string marketplaceSubscriptionName, string marketplaceResourceId, string marketplaceStatus, string billedAzureSubscriptionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MarketplaceSubscriptionId = marketplaceSubscriptionId;
            MarketplaceSubscriptionName = marketplaceSubscriptionName;
            MarketplaceResourceId = marketplaceResourceId;
            MarketplaceStatus = marketplaceStatus;
            BilledAzureSubscriptionId = billedAzureSubscriptionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Marketplace Subscription Id. This is a GUID-formatted string. </summary>
        [WirePath("marketplaceSubscriptionId")]
        public string MarketplaceSubscriptionId { get; }
        /// <summary> Marketplace Subscription Details: SAAS Name. </summary>
        [WirePath("marketplaceSubscriptionName")]
        public string MarketplaceSubscriptionName { get; }
        /// <summary> Marketplace Subscription Details: Resource URI. </summary>
        [WirePath("marketplaceResourceId")]
        public string MarketplaceResourceId { get; }
        /// <summary> Marketplace Subscription Details: SaaS Subscription Status. </summary>
        [WirePath("marketplaceStatus")]
        public string MarketplaceStatus { get; }
        /// <summary> The Azure Subscription ID to which the Marketplace Subscription belongs and gets billed into. </summary>
        [WirePath("billedAzureSubscriptionId")]
        public string BilledAzureSubscriptionId { get; }
    }
}
