// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NewRelicObservability
{
    internal class NewRelicMonitoredSubscriptionOperationSource : IOperationSource<NewRelicMonitoredSubscriptionResource>
    {
        private readonly ArmClient _client;

        internal NewRelicMonitoredSubscriptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        NewRelicMonitoredSubscriptionResource IOperationSource<NewRelicMonitoredSubscriptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NewRelicMonitoredSubscriptionData.DeserializeNewRelicMonitoredSubscriptionData(document.RootElement);
            return new NewRelicMonitoredSubscriptionResource(_client, data);
        }

        async ValueTask<NewRelicMonitoredSubscriptionResource> IOperationSource<NewRelicMonitoredSubscriptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NewRelicMonitoredSubscriptionData.DeserializeNewRelicMonitoredSubscriptionData(document.RootElement);
            return new NewRelicMonitoredSubscriptionResource(_client, data);
        }
    }
}
