// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NewRelicObservability
{
    internal class NewRelicMonitorResourceOperationSource : IOperationSource<NewRelicMonitorResource>
    {
        private readonly ArmClient _client;

        internal NewRelicMonitorResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        NewRelicMonitorResource IOperationSource<NewRelicMonitorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = NewRelicMonitorResourceData.DeserializeNewRelicMonitorResourceData(document.RootElement);
            return new NewRelicMonitorResource(_client, data);
        }

        async ValueTask<NewRelicMonitorResource> IOperationSource<NewRelicMonitorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = NewRelicMonitorResourceData.DeserializeNewRelicMonitorResourceData(document.RootElement);
            return new NewRelicMonitorResource(_client, data);
        }
    }
}
