// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.NewRelicObservability.Models;

namespace Azure.ResourceManager.NewRelicObservability.Samples
{
    public partial class Sample_NewRelicMonitoredSubscriptionResource
    {
        // Monitors_GetMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MonitorsGetMonitoredSubscriptions()
        {
            // Generated from example definition: specification/newrelic/resource-manager/NewRelic.Observability/stable/2024-03-01/examples/MonitoredSubscriptions_Get.json
            // this example is just showing the usage of "MonitoredSubscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NewRelicMonitoredSubscriptionResource created on azure
            // for more information of creating NewRelicMonitoredSubscriptionResource, please refer to the document of NewRelicMonitoredSubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            MonitoredSubscriptionConfigurationName configurationName = MonitoredSubscriptionConfigurationName.Default;
            ResourceIdentifier newRelicMonitoredSubscriptionResourceId = NewRelicMonitoredSubscriptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            NewRelicMonitoredSubscriptionResource newRelicMonitoredSubscription = client.GetNewRelicMonitoredSubscriptionResource(newRelicMonitoredSubscriptionResourceId);

            // invoke the operation
            NewRelicMonitoredSubscriptionResource result = await newRelicMonitoredSubscription.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NewRelicMonitoredSubscriptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Monitors_UpdateMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MonitorsUpdateMonitoredSubscriptions()
        {
            // Generated from example definition: specification/newrelic/resource-manager/NewRelic.Observability/stable/2024-03-01/examples/MonitoredSubscriptions_Update.json
            // this example is just showing the usage of "MonitoredSubscriptions_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NewRelicMonitoredSubscriptionResource created on azure
            // for more information of creating NewRelicMonitoredSubscriptionResource, please refer to the document of NewRelicMonitoredSubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            MonitoredSubscriptionConfigurationName configurationName = MonitoredSubscriptionConfigurationName.Default;
            ResourceIdentifier newRelicMonitoredSubscriptionResourceId = NewRelicMonitoredSubscriptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            NewRelicMonitoredSubscriptionResource newRelicMonitoredSubscription = client.GetNewRelicMonitoredSubscriptionResource(newRelicMonitoredSubscriptionResourceId);

            // invoke the operation
            NewRelicMonitoredSubscriptionData data = new NewRelicMonitoredSubscriptionData();
            ArmOperation<NewRelicMonitoredSubscriptionResource> lro = await newRelicMonitoredSubscription.UpdateAsync(WaitUntil.Completed, data);
            NewRelicMonitoredSubscriptionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            NewRelicMonitoredSubscriptionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Monitors_DeleteMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MonitorsDeleteMonitoredSubscriptions()
        {
            // Generated from example definition: specification/newrelic/resource-manager/NewRelic.Observability/stable/2024-03-01/examples/MonitoredSubscriptions_Delete.json
            // this example is just showing the usage of "MonitoredSubscriptions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this NewRelicMonitoredSubscriptionResource created on azure
            // for more information of creating NewRelicMonitoredSubscriptionResource, please refer to the document of NewRelicMonitoredSubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            MonitoredSubscriptionConfigurationName configurationName = MonitoredSubscriptionConfigurationName.Default;
            ResourceIdentifier newRelicMonitoredSubscriptionResourceId = NewRelicMonitoredSubscriptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            NewRelicMonitoredSubscriptionResource newRelicMonitoredSubscription = client.GetNewRelicMonitoredSubscriptionResource(newRelicMonitoredSubscriptionResourceId);

            // invoke the operation
            await newRelicMonitoredSubscription.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
