// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> The ingestion type. </summary>
    public readonly partial struct IngestionType : IEquatable<IngestionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IngestionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IngestionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IpfixValue = "IPFIX";

        /// <summary> IPFIX. </summary>
        public static IngestionType Ipfix { get; } = new IngestionType(IpfixValue);
        /// <summary> Determines if two <see cref="IngestionType"/> values are the same. </summary>
        public static bool operator ==(IngestionType left, IngestionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IngestionType"/> values are not the same. </summary>
        public static bool operator !=(IngestionType left, IngestionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IngestionType"/>. </summary>
        public static implicit operator IngestionType(string value) => new IngestionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IngestionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IngestionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
