// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Ingestion policy properties. </summary>
    public partial class IngestionSourcesPropertiesFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IngestionSourcesPropertiesFormat"/>. </summary>
        public IngestionSourcesPropertiesFormat()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IngestionSourcesPropertiesFormat"/>. </summary>
        /// <param name="sourceType"> Ingestion source type. </param>
        /// <param name="resourceId"> Resource ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IngestionSourcesPropertiesFormat(IngestionSourceType? sourceType, string resourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceType = sourceType;
            ResourceId = resourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Ingestion source type. </summary>
        public IngestionSourceType? SourceType { get; set; }
        /// <summary> Resource ID. </summary>
        public string ResourceId { get; set; }
    }
}
