// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Ingestion source type. </summary>
    public readonly partial struct IngestionSourceType : IEquatable<IngestionSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IngestionSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IngestionSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ResourceValue = "Resource";

        /// <summary> Resource. </summary>
        public static IngestionSourceType Resource { get; } = new IngestionSourceType(ResourceValue);
        /// <summary> Determines if two <see cref="IngestionSourceType"/> values are the same. </summary>
        public static bool operator ==(IngestionSourceType left, IngestionSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IngestionSourceType"/> values are not the same. </summary>
        public static bool operator !=(IngestionSourceType left, IngestionSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IngestionSourceType"/>. </summary>
        public static implicit operator IngestionSourceType(string value) => new IngestionSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IngestionSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IngestionSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
