// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Ingestion Policy properties. </summary>
    public partial class IngestionPolicyPropertiesFormat
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IngestionPolicyPropertiesFormat"/>. </summary>
        public IngestionPolicyPropertiesFormat()
        {
            IngestionSources = new ChangeTrackingList<IngestionSourcesPropertiesFormat>();
        }

        /// <summary> Initializes a new instance of <see cref="IngestionPolicyPropertiesFormat"/>. </summary>
        /// <param name="ingestionType"> The ingestion type. </param>
        /// <param name="ingestionSources"> Ingestion Sources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IngestionPolicyPropertiesFormat(IngestionType? ingestionType, IList<IngestionSourcesPropertiesFormat> ingestionSources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IngestionType = ingestionType;
            IngestionSources = ingestionSources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ingestion type. </summary>
        public IngestionType? IngestionType { get; set; }
        /// <summary> Ingestion Sources. </summary>
        public IList<IngestionSourcesPropertiesFormat> IngestionSources { get; }
    }
}
