// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Emission format type. </summary>
    public readonly partial struct EmissionType : IEquatable<EmissionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmissionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmissionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IpfixValue = "IPFIX";

        /// <summary> IPFIX. </summary>
        public static EmissionType Ipfix { get; } = new EmissionType(IpfixValue);
        /// <summary> Determines if two <see cref="EmissionType"/> values are the same. </summary>
        public static bool operator ==(EmissionType left, EmissionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmissionType"/> values are not the same. </summary>
        public static bool operator !=(EmissionType left, EmissionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmissionType"/>. </summary>
        public static implicit operator EmissionType(string value) => new EmissionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmissionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmissionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
