// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Emission destination type. </summary>
    public readonly partial struct EmissionDestinationType : IEquatable<EmissionDestinationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmissionDestinationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmissionDestinationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureMonitorValue = "AzureMonitor";

        /// <summary> AzureMonitor. </summary>
        public static EmissionDestinationType AzureMonitor { get; } = new EmissionDestinationType(AzureMonitorValue);
        /// <summary> Determines if two <see cref="EmissionDestinationType"/> values are the same. </summary>
        public static bool operator ==(EmissionDestinationType left, EmissionDestinationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmissionDestinationType"/> values are not the same. </summary>
        public static bool operator !=(EmissionDestinationType left, EmissionDestinationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmissionDestinationType"/>. </summary>
        public static implicit operator EmissionDestinationType(string value) => new EmissionDestinationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmissionDestinationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmissionDestinationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
